#include "MaFenetre.h"

MaFenetre::MaFenetre() : QWidget() //on hérite de QWidget ici
{
//initialisation de la liaison série
m_serialPort = new QextSerialPort("/dev/ttyACM0"); // établit la connexion avec le port

if ( !m_serialPort->open( QIODevice::ReadWrite | QIODevice::Unbuffered ) )
{

}
else
{
    m_serialPort->setBaudRate(BAUD9600);
    m_serialPort->setFlowControl(FLOW_OFF);
    m_serialPort->setParity(PAR_NONE);
    m_serialPort->setDataBits(DATA_8);
    m_serialPort->setStopBits(STOP_1);
}


//mise en place de la fenêtre
    setFixedSize(800,535);
    joueur=0;
    tour_eq1=1;
    tour_eq2=1;

//Mise en place du boutond de nouvelle partie
    m_bouton_nouvelle_partie = new QPushButton(this);
    m_bouton_nouvelle_partie -> setText("Nouvelle Partie");
    m_bouton_nouvelle_partie -> setCursor(Qt::PointingHandCursor);
    m_bouton_nouvelle_partie -> setFixedSize(150,35);
    m_bouton_nouvelle_partie -> setFont(QFont("Calibri", 12));
    m_bouton_nouvelle_partie -> move(10,10);

//Mise en place des cases du jeu de morpion
    m_bouton1 = new QPushButton(this);
    m_bouton1 -> setText("A1");
    m_bouton1 -> setCursor(Qt::PointingHandCursor);
    m_bouton1 -> setFixedSize(100,100);
    m_bouton1 -> setFont(QFont("Calibri", 20,QFont::Bold));
    m_bouton1 -> move(10,60);


    m_bouton2 = new QPushButton(this);
    m_bouton2 -> setText("A2");
    m_bouton2 -> setCursor(Qt::PointingHandCursor);
    m_bouton2 -> setFixedSize(100,100);
    m_bouton2 -> setFont(QFont("Calibri", 20,QFont::Bold));
    m_bouton2 -> move(110,60);

    m_bouton3 = new QPushButton(this);
    m_bouton3 -> setText("A3");
    m_bouton3 -> setCursor(Qt::PointingHandCursor);
    m_bouton3 -> setFixedSize(100,100);
    m_bouton3 -> setFont(QFont("Calibri", 20,QFont::Bold));
    m_bouton3 -> move(210,60);

    m_bouton4 = new QPushButton(this);
    m_bouton4 -> setText("B1");
    m_bouton4 -> setCursor(Qt::PointingHandCursor);
    m_bouton4 -> setFixedSize(100,100);
    m_bouton4 -> setFont(QFont("Calibri", 20,QFont::Bold));
    m_bouton4 -> move(10,160);

    m_bouton5 = new QPushButton(this);
    m_bouton5 -> setText("B2");
    m_bouton5 -> setCursor(Qt::PointingHandCursor);
    m_bouton5 -> setFixedSize(100,100);
    m_bouton5 -> setFont(QFont("Calibri", 20,QFont::Bold));
    m_bouton5 -> move(110,160);

    m_bouton6 = new QPushButton(this);
    m_bouton6 -> setText("B3");
    m_bouton6 -> setCursor(Qt::PointingHandCursor);
    m_bouton6 -> setFixedSize(100,100);
    m_bouton6 -> setFont(QFont("Calibri", 20,QFont::Bold));
    m_bouton6 -> move(210,160);

    m_bouton7 = new QPushButton(this);
    m_bouton7 -> setText("C1");
    m_bouton7 -> setCursor(Qt::PointingHandCursor);
    m_bouton7 -> setFixedSize(100,100);
    m_bouton7 -> setFont(QFont("Calibri", 20,QFont::Bold));
    m_bouton7 -> move(10,260);

    m_bouton8 = new QPushButton(this);
    m_bouton8 -> setText("C2");
    m_bouton8 -> setCursor(Qt::PointingHandCursor);
    m_bouton8 -> setFixedSize(100,100);
    m_bouton8 -> setFont(QFont("Calibri", 20,QFont::Bold));
    m_bouton8 -> move(110,260);

    m_bouton9 = new QPushButton(this);
    m_bouton9 -> setText("C3");
    m_bouton9 -> setCursor(Qt::PointingHandCursor);
    m_bouton9 -> setFixedSize(100,100);
    m_bouton9 -> setFont(QFont("Calibri", 20,QFont::Bold));
    m_bouton9 -> move(210,260);

//mise en place des sliders

    ///servo1
    m_slider1 = new QSlider(Qt::Horizontal,this);
    m_slider1 -> setRange(0,180);
    m_slider1 -> setGeometry(10,60,200,20);
    m_slider1 -> move(500,80);
    m_slider1 -> setValue(125);

    m_lcd1 = new QLCDNumber(this);
    m_lcd1 -> setSegmentStyle(QLCDNumber::Flat);
    m_lcd1 -> move(720,80);
    m_lcd1 -> display(125);

    QObject::connect(m_slider1, SIGNAL(valueChanged(int)), m_lcd1, SLOT(display(int))) ;

    ///servo2
    m_slider2 = new QSlider(Qt::Horizontal,this);
    m_slider2 -> setRange(0,180);
    m_slider2 -> setGeometry(10,60,200,20);
    m_slider2 -> move(500,130);
    m_slider2 -> setValue(15);

    m_lcd2 = new QLCDNumber(this);
    m_lcd2 -> setSegmentStyle(QLCDNumber::Flat);
    m_lcd2 -> move(720,130);
    m_lcd2 -> display(15);

    QObject::connect(m_slider2, SIGNAL(valueChanged(int)), m_lcd2, SLOT(display(int))) ;

    ///servo3
    m_slider3 = new QSlider(Qt::Horizontal,this);
    m_slider3 -> setRange(0,180);
    m_slider3 -> setGeometry(10,60,200,20);
    m_slider3 -> move(500,180);
    m_slider3 -> setValue(146);

    m_lcd3 = new QLCDNumber(this);
    m_lcd3 -> setSegmentStyle(QLCDNumber::Flat);
    m_lcd3 -> move(720,180);
    m_lcd3 -> display(146);

    QObject::connect(m_slider3, SIGNAL(valueChanged(int)), m_lcd3, SLOT(display(int))) ;

    ///servo4
    m_slider4 = new QSlider(Qt::Horizontal,this);
    m_slider4 -> setRange(0,180);
    m_slider4 -> setGeometry(10,60,200,20);
    m_slider4 -> move(500,230);
    m_slider4 -> setValue(45);

    m_lcd4 = new QLCDNumber(this);
    m_lcd4 -> setSegmentStyle(QLCDNumber::Flat);
    m_lcd4 -> move(720,230);
    m_lcd4 -> display(45);

    QObject::connect(m_slider4, SIGNAL(valueChanged(int)), m_lcd4, SLOT(display(int))) ;

    ///servo5
    m_slider5 = new QSlider(Qt::Horizontal,this);
    m_slider5 -> setRange(0,180);
    m_slider5 -> setGeometry(10,60,200,20);
    m_slider5 -> move(500,280);
    m_slider5 -> setValue(60);

    m_lcd5 = new QLCDNumber(this);
    m_lcd5 -> setSegmentStyle(QLCDNumber::Flat);
    m_lcd5 -> move(720,280);
    m_lcd5 -> display(60);

    QObject::connect(m_slider5, SIGNAL(valueChanged(int)), m_lcd5, SLOT(display(int))) ;

    ///servo6
    m_slider6 = new QSlider(Qt::Horizontal,this);
    m_slider6 -> setRange(0,180);
    m_slider6 -> setGeometry(10,60,200,20);
    m_slider6 -> move(500,330);
    m_slider6 -> setValue(130);
    m_lcd6 = new QLCDNumber(this);
    m_lcd6 -> setSegmentStyle(QLCDNumber::Flat);
    m_lcd6 -> move(720,330);
    m_lcd6 -> display(130);

    QObject::connect(m_slider6, SIGNAL(valueChanged(int)), m_lcd6, SLOT(display(int))) ;

//mise en place des boutons permettant le ramassage des pions
    m_bouton_ramasse_eq1 = new QPushButton(this);
    m_bouton_ramasse_eq1 -> setText("Ramasser Pion équipe 1");
    m_bouton_ramasse_eq1 -> setCursor(Qt::PointingHandCursor);
    m_bouton_ramasse_eq1 -> setFixedSize(380,50);
    m_bouton_ramasse_eq1 -> setFont(QFont("Calibri", 14));
    m_bouton_ramasse_eq1 -> move(10,400);
    m_bouton_ramasse_eq1 -> setStyleSheet("QPushButton { color : white;background-color: blue;border-style: outset;border-radius: 10px; } QPushButton:pressed {background-color: rgb(0, 0, 224); border-style: inset;   }");

    m_bouton_ramasse_eq2 = new QPushButton(this);
    m_bouton_ramasse_eq2 -> setText("Ramasser Pion équipe 2");
    m_bouton_ramasse_eq2 -> setCursor(Qt::PointingHandCursor);
    m_bouton_ramasse_eq2 -> setFixedSize(380,50);
    m_bouton_ramasse_eq2 -> setFont(QFont("Calibri", 14));
    m_bouton_ramasse_eq2 -> move(410,400);
    m_bouton_ramasse_eq2 -> setStyleSheet("QPushButton { color:white;background-color: black;border-style: outset;border-radius: 10px; } QPushButton:pressed {background-color: black; border-style: inset;   }");


//mise en place du bouton de remise en position de repos
    m_bouton_repos = new QPushButton(this);
    m_bouton_repos -> setText("Remise en Position Repos");
    m_bouton_repos -> setCursor(Qt::PointingHandCursor);
    m_bouton_repos -> setFixedSize(380,50);
    m_bouton_repos -> setFont(QFont("Calibri", 14));
    m_bouton_repos -> move(10,475);

//mise en place du bouton de réinitialisation de position
    m_bouton_reinit_pos = new QPushButton(this);
    m_bouton_reinit_pos -> setText("Réinitialisation des Coordonnées");
    m_bouton_reinit_pos -> setCursor(Qt::PointingHandCursor);
    m_bouton_reinit_pos -> setFixedSize(380,50);
    m_bouton_reinit_pos -> setFont(QFont("Calibri", 14));
    m_bouton_reinit_pos -> move(410,475);

    //mise en place du bouton témoin de la liaison série (si vert : connecté, si rouge : pas connecté)
        m_bouton_temoin = new QPushButton(this);
        m_bouton_temoin -> setFixedSize(25,25);
        m_bouton_temoin -> move(750,20);
        if ( !m_serialPort->open( QIODevice::ReadWrite | QIODevice::Unbuffered ) ) //ici on vérifie si la connexion est réalisée
        {
            m_bouton_temoin -> setStyleSheet("QPushButton{background-color:red;border-style: outset;border-radius: 10px;}");
            QMessageBox::warning(this, "Attention", "Le robot n'est pas connecté. \n Veuillez fermer la fenêtre de jeu et recommencer.");

        }
        else
        {
            m_bouton_temoin -> setStyleSheet("QPushButton{background-color:green;border-style: outset;border-radius: 10px;}");
        }

//connexion des slots
    //bouton repos
    QObject::connect(m_bouton_repos, SIGNAL(clicked()),this,SLOT(RemisePosRepos()));
    //boutons de position morpion
    QObject::connect(m_bouton1,SIGNAL(clicked()),this,SLOT(PosA1_defaut()));
    QObject::connect(m_bouton2,SIGNAL(clicked()),this,SLOT(PosA2_defaut()));
    QObject::connect(m_bouton3,SIGNAL(clicked()),this,SLOT(PosA3_defaut()));
    QObject::connect(m_bouton4,SIGNAL(clicked()),this,SLOT(PosB1_defaut()));
    QObject::connect(m_bouton5,SIGNAL(clicked()),this,SLOT(PosB2_defaut()));
    QObject::connect(m_bouton6,SIGNAL(clicked()),this,SLOT(PosB3_defaut()));
    QObject::connect(m_bouton7,SIGNAL(clicked()),this,SLOT(PosC1_defaut()));
    QObject::connect(m_bouton8,SIGNAL(clicked()),this,SLOT(PosC2_defaut()));
    QObject::connect(m_bouton9,SIGNAL(clicked()),this,SLOT(PosC3_defaut()));
    //boutons de récupération de pions
    QObject::connect(m_bouton_ramasse_eq1,SIGNAL(clicked()),this,SLOT(Ramasse_eq1()));
    QObject::connect(m_bouton_ramasse_eq2,SIGNAL(clicked()),this,SLOT(Ramasse_eq2()));
    //bouton de noubelle partie
    QObject::connect(m_bouton_nouvelle_partie,SIGNAL(clicked()),this,SLOT(NouvellePartie()));
    QObject::connect(m_bouton_reinit_pos,SIGNAL(clicked()),this,SLOT(reinit()));

    //connexion des sliders avec le port série
    QObject::connect(m_slider1, SIGNAL(valueChanged(int)) ,this,SLOT(sendData1(int)));
    QObject::connect(m_slider2, SIGNAL(valueChanged(int)) ,this,SLOT(sendData2(int)));
    QObject::connect(m_slider3, SIGNAL(valueChanged(int)) ,this,SLOT(sendData3(int)));
    QObject::connect(m_slider4, SIGNAL(valueChanged(int)) ,this,SLOT(sendData4(int)));
    QObject::connect(m_slider5, SIGNAL(valueChanged(int)) ,this,SLOT(sendData5(int)));
    QObject::connect(m_slider6, SIGNAL(valueChanged(int)) ,this,SLOT(sendData6(int)));

}


//création des slots

//position de repos
void MaFenetre::RemisePosRepos() //reste à définir les valeurs de position de repos!!
{
    if(joueur==1||joueur==2)
    {
        QMessageBox::warning(this, "Attention", "Vous devez d'abord déposer votre pion sur une case du jeu.");
    }
    else
    {
    m_slider2 -> setValue(15);
    m_slider3 -> setValue(146);
    m_slider4 -> setValue(45);
    m_slider5 -> setValue(60);
    m_slider1 -> setValue(125);
    m_slider6 -> setValue(130);
    }
}

//mise en position de jeu
void MaFenetre::PosC3_defaut()
{
    if(joueur==1) //si c'est le joueur 1 qui vient de prendre un pion, on va colorer la case en bleu
    {
        m_bouton9 -> setStyleSheet("QPushButton { color : white;background-color: blue;border-style: outset;border-radius: 10px; } QPushButton:pressed {background-color: rgb(0, 0, 224); border-style: inset;   }");
        m_bouton9->setEnabled(false);
        joueur=10; //variable joueur modifiée pour signifier que le joueur 1 a déposé son pion
    }
    else if (joueur==2) //idem pour colorer la case en noir
    {
        m_bouton9 -> setStyleSheet("QPushButton { color:white;background-color: black;border-style: outset;border-radius: 10px; } QPushButton:pressed {background-color: black; border-style: inset;   }");
        m_bouton9->setEnabled(false);
        joueur=20; //variable joueur modifiée pour signifier que le joueur 2 vient de jouer
    }

    //on va ensuite déposer le pion
    m_slider3 -> setValue(86);
    m_slider4 -> setValue(35);
    m_slider5 -> setValue(60);
    m_slider1 -> setValue(105);
    m_slider2 -> setValue(80);
    m_slider6 -> setValue(30);
    RemisePosRepos();
}

void MaFenetre::PosC2_defaut()
{
    if(joueur==1)
    {
        m_bouton8 -> setStyleSheet("QPushButton { color : white;background-color: blue;border-style: outset;border-radius: 10px; } QPushButton:pressed {background-color: rgb(0, 0, 224); border-style: inset;   }");
        m_bouton8->setEnabled(false);
        joueur=10;
    }
    else if (joueur==2)
    {
        m_bouton8 -> setStyleSheet("QPushButton { color:white;background-color: black;border-style: outset;border-radius: 10px; } QPushButton:pressed {background-color: black; border-style: inset;   }");
        m_bouton8->setEnabled(false);
        joueur=20;
    }
    m_slider3 -> setValue(95);
    m_slider4 -> setValue(35);
    m_slider5 -> setValue(60);
    m_slider1 -> setValue(117);
    m_slider2 -> setValue(79);
    m_slider6 -> setValue(30);
    RemisePosRepos();
}

void MaFenetre::PosC1_defaut()
{
    if(joueur==1)
    {
        m_bouton7 -> setStyleSheet("QPushButton { color : white;background-color: blue;border-style: outset;border-radius: 10px; } QPushButton:pressed {background-color: rgb(0, 0, 224); border-style: inset;   }");
        m_bouton7->setEnabled(false);
        joueur=10;
    }
    else if (joueur==2)
    {
        m_bouton7 -> setStyleSheet("QPushButton { color:white;background-color: black;border-style: outset;border-radius: 10px; } QPushButton:pressed {background-color: black; border-style: inset;   }");
        m_bouton7->setEnabled(false);
        joueur=20;
    }
    m_slider3 -> setValue(80);
    m_slider4 -> setValue(25);
    m_slider5 -> setValue(65);
    m_slider1 -> setValue(130);
    m_slider2 -> setValue(86);
    m_slider6 -> setValue(30);
    RemisePosRepos();
}

void MaFenetre::PosB3_defaut()
{
    if(joueur==1)
    {
        m_bouton6 -> setStyleSheet("QPushButton { color : white;background-color: blue;border-style: outset;border-radius: 10px; } QPushButton:pressed {background-color: rgb(0, 0, 224); border-style: inset;   }");
        m_bouton6->setEnabled(false);
        joueur=10;
    }
    else if (joueur==2)
    {
        m_bouton6 -> setStyleSheet("QPushButton { color:white;background-color: black;border-style: outset;border-radius: 10px; } QPushButton:pressed {background-color: black; border-style: inset;   }");
        m_bouton6->setEnabled(false);
        joueur=20;
    }
    m_slider3 -> setValue(106);
    m_slider4 -> setValue(35);
    m_slider5 -> setValue(60);
    m_slider1 -> setValue(100);
    m_slider2 -> setValue(65);
    m_slider6 -> setValue(30);
    RemisePosRepos();
}

void MaFenetre::PosB2_defaut()
{
    if(joueur==1)
    {
        m_bouton5 -> setStyleSheet("QPushButton { color : white;background-color: blue;border-style: outset;border-radius: 10px; } QPushButton:pressed {background-color: rgb(0, 0, 224); border-style: inset;   }");
        m_bouton5->setEnabled(false);
        joueur=10;
    }
    else if (joueur==2)
    {
        m_bouton5 -> setStyleSheet("QPushButton { color:white;background-color: black;border-style: outset;border-radius: 10px; } QPushButton:pressed {background-color: black; border-style: inset;   }");
        m_bouton5->setEnabled(false);
        joueur=20;
    }
    m_slider3 -> setValue(110);
    m_slider4 -> setValue(35);
    m_slider5 -> setValue(60);
    m_slider1 -> setValue(115);
    m_slider2 -> setValue(65);
    m_slider6 -> setValue(30);
    RemisePosRepos();
}

void MaFenetre::PosB1_defaut()
{
    if(joueur==1)
    {
        m_bouton4 -> setStyleSheet("QPushButton { color : white;background-color: blue;border-style: outset;border-radius: 10px; } QPushButton:pressed {background-color: rgb(0, 0, 224); border-style: inset;   }");
        m_bouton4->setEnabled(false);
        joueur=10;
    }
    else if (joueur==2)
    {
        m_bouton4 -> setStyleSheet("QPushButton { color:white;background-color: black;border-style: outset;border-radius: 10px; } QPushButton:pressed {background-color: black; border-style: inset;   }");
        m_bouton4->setEnabled(false);
        joueur=20;
    }
    m_slider3 -> setValue(106);
    m_slider4 -> setValue(35);
    m_slider5 -> setValue(60);
    m_slider1 -> setValue(140);
    m_slider2 -> setValue(75);
    m_slider6 -> setValue(30);
    RemisePosRepos();
}

void MaFenetre::PosA3_defaut()
{
    if(joueur==1)
    {
        m_bouton3 -> setStyleSheet("QPushButton { color : white;background-color: blue;border-style: outset; border-color : black; border-radius: 10px; } QPushButton:pressed {background-color: rgb(0, 0, 224); border-style: inset;   }");
        m_bouton3->setEnabled(false);
        joueur=10;
    }
    else if (joueur==2)
    {
        m_bouton3 -> setStyleSheet("QPushButton { color:white;background-color: black;border-style: outset;border-radius: 10px; } QPushButton:pressed {background-color: black; border-style: inset;   }");
        m_bouton3->setEnabled(false);
        joueur=20;
    }
    m_slider3 -> setValue(126);
    m_slider4 -> setValue(35);
    m_slider5 -> setValue(60);
    m_slider1 -> setValue(87);
    m_slider2 -> setValue(55);
    m_slider6 -> setValue(30);
    RemisePosRepos();
}

void MaFenetre::PosA2_defaut()
{
    if(joueur==1)
    {
        m_bouton2 -> setStyleSheet("QPushButton { color : white;background-color: blue;border-style: outset;border-radius: 10px; } QPushButton:pressed {background-color: rgb(0, 0, 224); border-style: inset;   }");
        m_bouton2->setEnabled(false);
        joueur=10;
    }
    else if (joueur==2)
    {
        m_bouton2 -> setStyleSheet("QPushButton { color:white;background-color: black;border-style: outset;border-radius: 10px; } QPushButton:pressed {background-color: black; border-style: inset;   }");
        m_bouton2->setEnabled(false);
        joueur=20;
    }
    m_slider3 -> setValue(136);
    m_slider4 -> setValue(45);
    m_slider5 -> setValue(60);
    m_slider1 -> setValue(120);
    m_slider2 -> setValue(55);
    m_slider6 -> setValue(30);
    RemisePosRepos();
}

void MaFenetre::PosA1_defaut()
{
    if(joueur==1)
    {
        m_bouton1 -> setStyleSheet("QPushButton { color : white;background-color: blue;border-style: outset;border-radius: 10px; } QPushButton:pressed {background-color: rgb(0, 0, 224); border-style: inset;   }");
        m_bouton1->setEnabled(false);
        joueur=10;
    }
    else if (joueur==2)
    {
        m_bouton1 -> setStyleSheet("QPushButton { color:white;background-color: black;border-style: outset;border-radius: 10px; } QPushButton:pressed {background-color: black; border-style: inset;   }");
        m_bouton1->setEnabled(false);
        joueur=20;
    }
    m_slider3 -> setValue(126);
    m_slider4 -> setValue(35);
    m_slider5 -> setValue(60);
    m_slider1 -> setValue(145);
    m_slider2 -> setValue(65);
    m_slider6 -> setValue(30);
    RemisePosRepos();
}

//mise en position de prise de pion
void MaFenetre::Ramasse_eq1()
{   if(joueur==1||joueur==2)
    {
        QMessageBox::warning(this, "Attention", "Vous devez d'abord déposer votre pion sur une case du jeu.");
    }

    else if(joueur==10) //cela est signe que c'est l'équipe 1 qui a joué le dernier coup
    {
        QMessageBox::critical(this, "Tricheur !", "Ce n'est pas à votre tour de jouer !!");
    }

    else
    {
  //il se baisse pour ramasser le pion en fonction du tour où l'on se trouve
    if(tour_eq1==1)
    {
        m_slider6 -> setValue(30);
        m_slider1 -> setValue(178);
        m_slider3 -> setValue(106);
        m_slider4 -> setValue(25);
        m_slider5 -> setValue(110);
        m_slider2 -> setValue(75);
        m_slider6 -> setValue(70);
        tour_eq1++;
    }
    else if(tour_eq1==2){
        m_slider6 -> setValue(30);
        m_slider1 -> setValue(170);
        m_slider3 -> setValue(96);
        m_slider4 -> setValue(25);
        m_slider5 -> setValue(90);
        m_slider2 -> setValue(75);
        m_slider6 -> setValue(70);
        tour_eq1++;
    }
    else if(tour_eq1==3){
        m_slider6 -> setValue(30);
        m_slider1 -> setValue(165);
        m_slider3 -> setValue(86);
        m_slider4 -> setValue(25);
        m_slider5 -> setValue(90);
        m_slider2 -> setValue(75);
        m_slider6 -> setValue(70);
        tour_eq1++;
    }
    else if(tour_eq1==4){
        m_slider6 -> setValue(30);
        m_slider1 -> setValue(158);
        m_slider3 -> setValue(70);
        m_slider4 -> setValue(15);
        m_slider5 -> setValue(90);
        m_slider2 -> setValue(80);
        m_slider6 -> setValue(70);
        tour_eq1++;
    }
    else if(tour_eq1==5){
        m_slider6 -> setValue(30);
        m_slider1 -> setValue(155);
        m_slider3 -> setValue(46);
        m_slider4 -> setValue(0);
        m_slider5 -> setValue(75);
        m_slider2 -> setValue(95);
        m_slider6 -> setValue(80);
        tour_eq1++;
    }
    else
    {
      QMessageBox::warning(this, "Attention", "L'équipe 1 n'a plus de pion !!");  //signale que le joueur n'a plus de pion
    }

  //il revient en position de repos
    m_slider2 -> setValue(15);
    m_slider3 -> setValue(146);
    m_slider4 -> setValue(45);
    m_slider5 -> setValue(60);
    m_slider1 -> setValue(125);


    joueur = 1;
    }
}

void MaFenetre::Ramasse_eq2()
{
    if(joueur==20) //cela indique que c'est l'équipe 2 qui a joué le dernier coup
    {
        QMessageBox::critical(this, "Tricheur !", "Ce n'est pas à votre tour de jouer !!");
    }
    else if(joueur==1||joueur==2)
    {
        QMessageBox::warning(this, "Attention", "Vous devez d'abord déposer votre pion sur une case du jeu.");
    }
    else {
  //il se baisse pour ramasser le pion
    if(tour_eq2==1)
    {
        m_slider6 -> setValue(30);
        m_slider1 -> setValue(56);
        m_slider3 -> setValue(116);
        m_slider4 -> setValue(25);
        m_slider5 -> setValue(10);
        m_slider2 -> setValue(65);
        m_slider6 -> setValue(70);
        tour_eq2++;
    }
    else if(tour_eq2==2)
    {
        m_slider6 -> setValue(30);
        m_slider1 -> setValue(65);
        m_slider3 -> setValue(116);
        m_slider4 -> setValue(35);
        m_slider5 -> setValue(20);
        m_slider2 -> setValue(65);
        m_slider6 -> setValue(70);
        tour_eq2++;
    }
    else if(tour_eq2==3)
    {
        m_slider6 -> setValue(30);
        m_slider1 -> setValue(70);
        m_slider3 -> setValue(100);
        m_slider4 -> setValue(25);
        m_slider5 -> setValue(20);
        m_slider2 -> setValue(75);
        m_slider6 -> setValue(70);
        tour_eq2++;
    }
    else if(tour_eq2==4) //revoir cette position !!!!!!
    {
        m_slider6 -> setValue(30);
        m_slider3 -> setValue(93);
        m_slider4 -> setValue(25);
        m_slider5 -> setValue(20);
        m_slider1 -> setValue(75);
        m_slider2 -> setValue(85);
        m_slider6 -> setValue(70);
        tour_eq2++;
    }
    else if(tour_eq2==5)
    {
        m_slider6 -> setValue(30);
        m_slider1 -> setValue(85);
        m_slider3 -> setValue(56);
        m_slider4 -> setValue(5);
        m_slider5 -> setValue(40);
        m_slider2 -> setValue(90);
        m_slider6 -> setValue(70);
        tour_eq2++;
    }
    else
    {
        QMessageBox::warning(this, "Attention", "L'équipe 2 n'a plus de pion !!");  //signale que le joueur n'a plus de pion
    }

  //il revient en position de repos
    m_slider2 -> setValue(15);
    m_slider3 -> setValue(146);
    m_slider4 -> setValue(45);
    m_slider5 -> setValue(60);
    m_slider1 -> setValue(125);


    joueur = 2;
}
}
void MaFenetre::NouvellePartie()
{
    if(joueur==1||joueur==2)
    {
        m_slider3 -> setValue(136);
        m_slider4 -> setValue(25);
        m_slider1 -> setValue(180);
        m_slider5 -> setValue(50);
        m_slider2 -> setValue(65);
        m_slider6 -> setValue(30);
    }
    //remise des servos en position de repos
    m_slider3 -> setValue(146);
    m_slider4 -> setValue(45);
    m_slider5 -> setValue(60);
    m_slider2 -> setValue(15);
    m_slider1 -> setValue(125);
    m_slider6 -> setValue(130);

    joueur =0 ; //remise du joueur à personne et des indicateur du tour à 1
    tour_eq1=1;
    tour_eq2=1;

//réinitialisation des cases du jeu
    m_bouton1 -> setStyleSheet("default");
    m_bouton1->setEnabled(true);
    m_bouton2 -> setStyleSheet("default");
    m_bouton2->setEnabled(true);
    m_bouton3 -> setStyleSheet("default");
    m_bouton3->setEnabled(true);
    m_bouton4 -> setStyleSheet("default");
    m_bouton4->setEnabled(true);
    m_bouton5 -> setStyleSheet("default");
    m_bouton5->setEnabled(true);
    m_bouton6 -> setStyleSheet("default");
    m_bouton6->setEnabled(true);
    m_bouton7 -> setStyleSheet("default");
    m_bouton7->setEnabled(true);
    m_bouton8 -> setStyleSheet("default");
    m_bouton8->setEnabled(true);
    m_bouton9 -> setStyleSheet("default");
    m_bouton9->setEnabled(true);

}

void MaFenetre::reinit()
{
    QMessageBox::information(this, "Réinitialisation des Coordonnées", "Cette Fonction n'est pas encore disponible");
}

//slots d'envoi de données au robot via liaison série
void MaFenetre::sendData1(int data)
{
    char * pouet = new char[5];
    int res;

    if(m_serialPort->isOpen() == true)
    {
    res=1000+data;
      sprintf(pouet,"%d",res);
      /* Décalage pour ajoute le & */
      pouet[4] = pouet[3];
      pouet[3] = pouet[2];
      pouet[2] = pouet[1];
      pouet[1] = pouet[0];
      pouet[0] = '&';
        m_serialPort->write(pouet,5); // On envoie un char du coup l'algo de déchiffrage au bout devrait fonctionner
    }
    else
    {

    }

}

void MaFenetre::sendData2(int data)
{
    char * pouet = new char[5];
    int res;

    if(m_serialPort->isOpen() == true)
    {
    res=2000+data;
      sprintf(pouet,"%d",res);
      /* Décalage pour ajoute le & */
      pouet[4] = pouet[3];
      pouet[3] = pouet[2];
      pouet[2] = pouet[1];
      pouet[1] = pouet[0];
      pouet[0] = '&';
        m_serialPort->write(pouet,5); // On envoie un char du coup l'algo de déchiffrage au bout devrait fonctionner
    }
    else
    {

    }

}

void MaFenetre::sendData3(int data)
{
    char * pouet = new char[5];
    int res;

    if(m_serialPort->isOpen() == true)
    {
    res=3000+data;
      sprintf(pouet,"%d",res);
      /* Décalage pour ajoute le & */
      pouet[4] = pouet[3];
      pouet[3] = pouet[2];
      pouet[2] = pouet[1];
      pouet[1] = pouet[0];
      pouet[0] = '&';
        m_serialPort->write(pouet,5); // On envoie un char du coup l'algo de déchiffrage au bout devrait fonctionner
    }
    else
    {

    }

}

void MaFenetre::sendData4(int data)
{
    char * pouet = new char[5];
    int res;

    if(m_serialPort->isOpen() == true)
    {
    res=4000+data;
      sprintf(pouet,"%d",res);
      /* Décalage pour ajoute le & */
      pouet[4] = pouet[3];
      pouet[3] = pouet[2];
      pouet[2] = pouet[1];
      pouet[1] = pouet[0];
      pouet[0] = '&';
        m_serialPort->write(pouet,5); // On envoie un char du coup l'algo de déchiffrage au bout devrait fonctionner
    }
    else
    {

    }

}

void MaFenetre::sendData5(int data)
{
    char * pouet = new char[5];
    int res;

    if(m_serialPort->isOpen() == true)
    {
    res=5000+data;
      sprintf(pouet,"%d",res);
      /* Décalage pour ajoute le & */
      pouet[4] = pouet[3];
      pouet[3] = pouet[2];
      pouet[2] = pouet[1];
      pouet[1] = pouet[0];
      pouet[0] = '&';
        m_serialPort->write(pouet,5); // On envoie un char du coup l'algo de déchiffrage au bout devrait fonctionner
    }
    else
    {

    }

}

void MaFenetre::sendData6(int data)
{
    char * pouet = new char[5];
    int res;

    if(m_serialPort->isOpen() == true)
    {
    res=6000+data;
      sprintf(pouet,"%d",res);
      /* Décalage pour ajoute le & */
      pouet[4] = pouet[3];
      pouet[3] = pouet[2];
      pouet[2] = pouet[1];
      pouet[1] = pouet[0];
      pouet[0] = '&';
        m_serialPort->write(pouet,5); // On envoie un char du coup l'algo de déchiffrage au bout devrait fonctionner
    }
    else
    {

    }

}

MaFenetre::~MaFenetre() // Destructeur
{
    delete m_serialPort;
}
