/******************************************************************************\
* Copyright (C) 2012-2013 Leap Motion, Inc. All rights reserved.               *
* Leap Motion proprietary and confidential. Not for distribution.              *
* Use subject to the terms of the Leap Motion SDK Agreement available at       *
* https://developer.leapmotion.com/sdk_agreement, or another agreement         *
* between Leap Motion and you, your company or other organization.             *
\******************************************************************************/

#include <iostream>
#include "Leap.h"
#include "stdlib.h"
#include <Windows.h>
using namespace Leap;

#define ERREUR_NB_MAIN -1

class SampleListener : public Listener {
  public:
    virtual void onInit(const Controller&);
    virtual void onConnect(const Controller&);
    virtual void onDisconnect(const Controller&);
    virtual void onExit(const Controller&);
    virtual void onFrame(const Controller&);
    virtual void onFocusGained(const Controller&);
    virtual void onFocusLost(const Controller&);
	virtual void init_tab_servo();
	virtual int mains(const Controller&);
	virtual void calcul_angle(const Controller&);
	virtual void infos_doigt_commande(const Controller&,int main_d);
	virtual INFOS_ROBOT get_infos_robot();

private :

	INFOS_LEAP infos_leap ;
	INFOS_ROBOT infos_robot;
	SERVO tab_servo[6];
	INFOS_LEAP tab_moyen[10];

};


void SampleListener::onInit(const Controller& controller) {
  std::cout << "Initialized" << std::endl;
}

void SampleListener::onConnect(const Controller& controller) {
  std::cout << "Connected" << std::endl;
  controller.enableGesture(Gesture::TYPE_CIRCLE);
  controller.enableGesture(Gesture::TYPE_KEY_TAP);
  controller.enableGesture(Gesture::TYPE_SCREEN_TAP);
  controller.enableGesture(Gesture::TYPE_SWIPE);
}

void SampleListener::onDisconnect(const Controller& controller) {
  //Note: not dispatched when running in a debugger.
  std::cout << "Disconnected" << std::endl;
}

void SampleListener::onExit(const Controller& controller) {
  std::cout << "Exited" << std::endl;
}

void SampleListener::init_tab_servo(){
	//Initialisation des servos
	tab_servo[0].a_min = 0;
	tab_servo[0].a_max = 180;
	tab_servo[0].numero = 1;

	tab_servo[1].a_min = 0;
	tab_servo[1].a_max = 70;
	tab_servo[1].numero = 2;

	tab_servo[2].a_min = 0;
	tab_servo[2].a_max = 100;
	tab_servo[2].numero = 3;

	tab_servo[3].a_min = 10;
	tab_servo[3].a_max = 65;
	tab_servo[3].numero = 4;

	tab_servo[4].a_min = 0;
	tab_servo[4].a_max = 180;
	tab_servo[4].numero = 5;

	tab_servo[5].a_min = 0;
	tab_servo[5].a_max = 135;
	tab_servo[5].numero = 6;
}

int SampleListener::mains(const Controller& controller){
	int j;
	int mains;
	float m[2] = {-500,-500};
	int main_g,main_d;
	main_d =0;
	main_g = 0;

	// Get the most recent frame
	const Frame frame = controller.frame();	
	//Enregistrer le nombre de mains visibles			
	mains = frame.hands().count();
	std::cout << "Valeur de la variable mains : " << mains << std::endl;
	
	if (mains > 2) {
		std::cout << "Un humain normalement constitue ne possede pas plus de deux mains, Tricheur !" << std::endl;
		infos_robot.servo = 7; //Valeur par dfaut qui indique qu'aucun servo n'est control
		return ERREUR_NB_MAIN;
	}
	else if (mains == 1 || mains == 0) {
		std::cout << "Aucun servo moteur n'est designe" << std::endl;
		infos_robot.servo = 7; //Valeur par dfaut qui indique qu'aucun servo n'est control
		return ERREUR_NB_MAIN;
	}
	else {
		for (j=0;j<mains;j++) {
			if (!frame.hands().isEmpty()) {
				// Get the first hand
				const Hand hand = frame.hands()[j];
				// Check if the hand has any fingers
				const FingerList fingers = hand.fingers();
				if (!fingers.isEmpty()) {
					// Calculate the hand's average finger tip position
					float avgPos = 0;
					for (int i = 0; i < fingers.count(); ++i) {
					avgPos += (fingers[i].tipPosition())[0];
					}
				avgPos /= (float)fingers.count();
				m[j]=avgPos;
				}
			}	
		}
	
		if (m[0]>m[1]) {
			main_d = 0;
			main_g = 1;
		}
		else {
			main_d = 1;
			main_g = 0;
		}
		std::cout << "Position moyenne main gauche : " << m[main_g] << " Position moyenne main droite : " << m[main_d] << std::endl;
		return main_d;
	}
}

void SampleListener::infos_doigt_commande(const Controller& controller,int main_d){
		const Frame frame = controller.frame();
		Vector vecteur_coor;

		// Rcupration de la main droite
		const Hand hand = frame.hands()[main_d];
		// Check if the hand has any fingers
		const FingerList fingers = hand.fingers();
		vecteur_coor = fingers[0].tipPosition();
		
		infos_leap.nbr_doigts = frame.fingers().count();
		infos_leap.x = vecteur_coor[0];
		infos_leap.y = vecteur_coor[2];
		infos_leap.z = vecteur_coor[1];
		
		infos_robot.servo = infos_leap.nbr_doigts;
	
		std::cout << "\nServo a controller : " << infos_robot.servo << " Position du doigt de commande : " << infos_leap.z << std::endl;
}

void SampleListener::calcul_angle(const Controller& controller){
		int cpt = 0;

		if ( infos_robot.servo > 6) {
			std::cout << "Position de la main non standardise (Un doigt a droite)" << std::endl;
			infos_robot.servo = 7; //Valeur par dfaut qui indique qu'aucun servo n'est control
		}
		else {
			SERVO c_servo = tab_servo[0];
			while (c_servo.numero != infos_robot.servo && cpt <6) {
			c_servo = tab_servo[cpt];
			cpt ++;
			}
			infos_robot.angle = floor(c_servo.a_min + (floor(infos_leap.z) - Z_MIN)*(c_servo.a_max - c_servo.a_min)/(Z_MAX - Z_MIN));
			if (infos_robot.angle > c_servo.a_max) { infos_robot.angle = c_servo.a_max; };
			if (infos_robot.angle < c_servo.a_min) { infos_robot.angle = c_servo.a_min; };

			std::cout << "\nNumero du servo : " << c_servo.numero << " Angle  : " << infos_robot.angle << std::endl;
		}
}

INFOS_ROBOT SampleListener::get_infos_robot(){
	return infos_robot;
}

///////////////////////////*Mthode principale*/////////////////////////////////////////////////////////

void SampleListener::onFrame(const Controller& controller) {

	infos_robot.servo = 7;
	infos_robot.angle = 0;
	
	int main_d;
	
	main_d = SampleListener::mains(controller);
	
	if (main_d != ERREUR_NB_MAIN) {
		SampleListener::infos_doigt_commande(controller,main_d);
		SampleListener::calcul_angle(controller);
	}

	
	Sleep(200);
	system("cls");
}

void SampleListener::onFocusGained(const Controller& controller) {
  std::cout << "Focus Gained" << std::endl;
}

void SampleListener::onFocusLost(const Controller& controller) {
  std::cout << "Focus Lost" << std::endl;
}

int main() {

  // Create a sample listener and controller
  SampleListener listener;
  Controller controller;
 
	listener.init_tab_servo();

  // Have the sample listener receive events from the controller
  controller.addListener(listener);

  // Keep this process running until Enter is pressed

  std::cout << "Press Enter to quit..." << std::endl;
  std::cin.get();

  // Remove the sample listener when done
  controller.removeListener(listener);

  return 0;
}
